/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE);
    }

    private Splitter(Strategy strategy, boolean bl, CharMatcher charMatcher) {
        this.strategy = strategy;
        this.omitEmptyStrings = bl;
        this.trimmer = charMatcher;
    }

    public static Splitter on(char c) {
        return Splitter.on(CharMatcher.is(c));
    }

    public static Splitter on(final CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    int separatorStart(int n) {
                        return charMatcher.indexIn(this.toSplit, n);
                    }

                    int separatorEnd(int n) {
                        return n + 1;
                    }
                };
            }
        });
    }

    public static Splitter on(final String string) {
        Preconditions.checkArgument(string.length() != 0, "The separator may not be the empty string.");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    public int separatorStart(int n) {
                        int n2 = string.length();
                        int n3 = this.toSplit.length() - n2;
                        block0: for (int i = n; i <= n3; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                if (this.toSplit.charAt(j + i) != string.charAt(j)) continue block0;
                            }
                            return i;
                        }
                        return -1;
                    }

                    public int separatorEnd(int n) {
                        return n + string.length();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter on(final Pattern pattern) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkArgument(!pattern.matcher("").matches(), "The pattern may not match the empty string: %s", pattern);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                final Matcher matcher = pattern.matcher(charSequence);
                return new SplittingIterator(splitter, charSequence){

                    public int separatorStart(int n) {
                        return matcher.find(n) ? matcher.start() : -1;
                    }

                    public int separatorEnd(int n) {
                        return matcher.end();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter onPattern(String string) {
        return Splitter.on(Pattern.compile(string));
    }

    public static Splitter fixedLength(final int n) {
        Preconditions.checkArgument(n > 0, "The length may not be less than 1");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    public int separatorStart(int n) {
                        int n2 = n + n;
                        return n2 < this.toSplit.length() ? n2 : -1;
                    }

                    public int separatorEnd(int n) {
                        return n;
                    }
                };
            }
        });
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    public Splitter trimResults(CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(this.strategy, this.omitEmptyStrings, charMatcher);
    }

    public Iterable<String> split(final CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Splitter.this.strategy.iterator(Splitter.this, charSequence);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        State state = State.NOT_READY;
        T next;

        private AbstractIterator() {
        }

        protected abstract T computeNext();

        protected final T endOfData() {
            this.state = State.DONE;
            return null;
        }

        @Override
        public final boolean hasNext() {
            Preconditions.checkState(this.state != State.FAILED);
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            return this.tryToComputeNext();
        }

        boolean tryToComputeNext() {
            this.state = State.FAILED;
            this.next = this.computeNext();
            if (this.state != State.DONE) {
                this.state = State.READY;
                return true;
            }
            return false;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = State.NOT_READY;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            READY,
            NOT_READY,
            DONE,
            FAILED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence charSequence) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.toSplit = charSequence;
        }

        @Override
        protected String computeNext() {
            while (this.offset != -1) {
                int n;
                int n2 = this.offset;
                int n3 = this.separatorStart(this.offset);
                if (n3 == -1) {
                    n = this.toSplit.length();
                    this.offset = -1;
                } else {
                    n = n3;
                    this.offset = this.separatorEnd(n3);
                }
                while (n2 < n && this.trimmer.matches(this.toSplit.charAt(n2))) {
                    ++n2;
                }
                while (n > n2 && this.trimmer.matches(this.toSplit.charAt(n - 1))) {
                    --n;
                }
                if (this.omitEmptyStrings && n2 == n) continue;
                return ((Object)this.toSplit.subSequence(n2, n)).toString();
            }
            return (String)this.endOfData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

